<?php
$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $brand = $_POST['brand'] ?? '';
    $model = $_POST['model'] ?? '';
    $year = $_POST['year'] ?? '';
    $color = $_POST['color'] ?? '';
    $price = $_POST['price'] ?? '';
    $status = $_POST['status'] ?? 'available';
    
    if (!empty($brand) && !empty($model) && !empty($year) && !empty($price)) {
        $stmt = $conn->prepare("INSERT INTO cars (brand, model, year, color, price_per_day, status) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("ssisss", $brand, $model, $year, $color, $price, $status);
        
        if ($stmt->execute()) {
            $success = "تم إضافة السيارة بنجاح!";
            // إفراغ الحقول بعد النجاح
            $brand = $model = $year = $color = $price = '';
        } else {
            $error = "حدث خطأ أثناء إضافة السيارة";
        }
        $stmt->close();
    } else {
        $error = "يرجى ملء جميع الحقول المطلوبة";
    }
}
?>

<?php if ($success): ?>
    <div class="success-message"><?php echo $success; ?></div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="error-message"><?php echo $error; ?></div>
<?php endif; ?>

<div class="table-container">
    <h2 style="margin-bottom: 25px; color: #2c3e50;">إضافة سيارة جديدة</h2>
    
    <form method="POST" action="">
        <div class="form-group">
            <label for="brand">الماركة *</label>
            <input type="text" id="brand" name="brand" required 
                   value="<?php echo htmlspecialchars($brand ?? ''); ?>">
        </div>
        
        <div class="form-group">
            <label for="model">الموديل *</label>
            <input type="text" id="model" name="model" required 
                   value="<?php echo htmlspecialchars($model ?? ''); ?>">
        </div>
        
        <div class="form-group">
            <label for="year">سنة الصنع *</label>
            <input type="number" id="year" name="year" min="1950" max="2030" required 
                   value="<?php echo htmlspecialchars($year ?? ''); ?>">
        </div>
        
        <div class="form-group">
            <label for="color">اللون</label>
            <input type="text" id="color" name="color" 
                   value="<?php echo htmlspecialchars($color ?? ''); ?>">
        </div>
        
        <div class="form-group">
            <label for="price">السعر لليوم (ريال) *</label>
            <input type="number" id="price" name="price" step="0.01" min="0" required 
                   value="<?php echo htmlspecialchars($price ?? ''); ?>">
        </div>
        
        <div class="form-group">
            <label for="status">الحالة *</label>
            <select id="status" name="status">
                <option value="available">متاحة</option>
                <option value="rented">مؤجرة</option>
                <option value="maintenance">صيانة</option>
            </select>
        </div>
        
        <button type="submit" class="btn btn-primary">حفظ السيارة</button>
        <a href="?page=cars" class="btn" style="background-color: #95a5a6; color: white; margin-right: 10px;">إلغاء</a>
    </form>
</div>